package gov.va.vinci.dart.rule;

import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.DataSource;
import gov.va.vinci.dart.biz.DocumentTemplate;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Location;
import gov.va.vinci.dart.biz.Participant;

/**
 * The Interface DocumentRuleEvaluator.
 */
public interface DocumentRuleEvaluator {

    /**
     * Checks if is required.
     *
     * @param request
     *            the request
     * @param datasource
     *            the datasource
     * @param documentTemplate
     *            the document template
     * @param location
     *            the location
     * @param isIndependentOnly
     *            the is independent only
     * @return true, if is required
     */
    boolean isRequired(Request request, DataSource datasource, DocumentTemplate documentTemplate, Location location,
            final boolean isIndependentOnly);

    /**
     * Checks if is required.
     *
     * @param request
     *            the request
     * @param datasource
     *            the datasource
     * @param documentTemplate
     *            the document template
     * @param participant
     *            the participant
     * @param isIndependentOnly
     *            the is independent only
     * @return true, if is required
     */
    boolean isRequired(Request request, DataSource datasource, DocumentTemplate documentTemplate, Participant participant,
            final boolean isIndependentOnly);

    /**
     * Checks if is required.
     *
     * @param request
     *            the request
     * @param datasource
     *            the datasource
     * @param documentTemplate
     *            the document template
     * @param admin
     *            the admin
     * @param location
     *            the location
     * @param isIndependentOnly
     *            the is independent only
     * @return true, if is required
     */
    boolean isRequired(Request request, DataSource datasource, DocumentTemplate documentTemplate, Group admin,
            Location location, final boolean isIndependentOnly);

    /**
     * Checks if is required.
     *
     * @param request
     *            the request
     * @param datasource
     *            the datasource
     * @param documentTemplate
     *            the document template
     * @param admin
     *            the admin
     * @param participant
     *            the participant
     * @param isIndependentOnly
     *            the is independent only
     * @return true, if is required
     */
    boolean isRequired(Request request, DataSource datasource, DocumentTemplate documentTemplate, Group admin,
            Participant participant, final boolean isIndependentOnly);
}
